% file: example1.m	G. Clifford and G. Moody	6 December 2003

fprintf('example1.m - demonstration of reading signals using WFDB_tools\n')

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script is part of a brief 'hands on' tutorial for the WFDB_tools
% package.  Before running this script, you will need to have correctly
% installed the WFDB software package and added the Matlab WFDB_tools
% path at the Matlab prompt.
%
% Please report any problems with this script to Gari Clifford:
%	gari AT physionet DOT org
% Please report any problems with WFDB_tools for Matlab to Jonas Carlson:
%       jonas DOT carlson AT kard DOT lu DOT se
% Please report any problems with the WFDB software package to George Moody:
%       george AT physionet DOT org

% Set pauseflag to 0 before running this script to disable pauses.
if(~exist('pauseflag')) pauseflag=1; end

% Check that the WFDB_tools functions are installed and accessible.
if(exist('WFDB_isigopen')==0)
  fprintf('Please add WFDB_tools to the PATH ...');
  if(isunix)
     error(' e.g.,\n     addpath ~/matlab/WFDB_tools/\n');
  elseif(ispc)
     error(' e.g.,\n     addpath c:\\matlab\\WFDB_tools\n');
  else
     error('... ');
  end
end

% Check that the WFDB software package is installed and accessible.
if system('rdann -r mitdb/201 -a atr -c 1')
  fprintf('The WFDB software package does not seem to be installed.\n');
  error('Install it and add the directory containing "rdann" to your PATH.\n');
end

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

% End of standard setup.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Choose an input record.
record = 'mitdb/201';

% Open the signals.
fprintf('We begin by opening the input signals, using\n');
fprintf('   hea = WFDB_isigopen(record);\n');
fprintf('Information about the signals is loaded into "hea":\n');
hea = WFDB_isigopen(record)

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

fprintf('\n\nSo, for example, hea(1).gain is the gain of signal 0:\n');
hea(1).gain
fprintf('and hea(2).desc is a description of signal 1:\n');
hea(2).desc
fprintf('(i.e., signal 1 is lead V1 of an ECG).\n')

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

% Read samples of the signals.
fprintf('\nWe can load the first 5 points (samples 0-4) of each signal by:\n');
fprintf('   data = WFDB_getvec(length(hea),5)\n');
data = WFDB_getvec(length(hea),5)

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

fprintf('\nWe can load the next 5 points (samples 5-9) of each signal by\n');
fprintf('repeating the previous call:  data = WFDB_getvec(length(hea),5)\n');
data = WFDB_getvec(length(hea),5)

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

fprintf('\nTo begin reading at any given sample number, we can pass that\n');
fprintf('sample number as a third argument to WFDB_getvec.  For example,');
fprintf('we can plot the first 1000 points (samples 0 through 999) of\n');
fprintf('two signals by\n');
fprintf('   figure(1);plot(WFDB_getvec(length(hea),1000,0));\n');

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

figure(1);plot(WFDB_getvec(length(hea),1000));

fprintf('\n\nWe finish by closing all files with WFDB_wfdbquit\n');
WFDB_wfdbquit
fprintf('\nWFDB_wfdbquit successful, end of example1.m\n');

