% ANN = WFDB_Annotation(NANN);
%
% Create annotation data structure(s) for use with WFDB_putann.
%
% NANN: Number of annotations
% ANN: Resulting Annotation structure(s)
%
% The fields of ANN are defaulted as:
%   time - 1, 2, 3 ...
%   anntyp - 1
%   subtyp - 0
%   chan - 0
%   num - 0
%   aux - ''
%
% aux may be any string.
%
% http://www.physionet.org

function ANN = WFDB_Annotation(NANN);

for ii = 1:NANN
    ANN(ii) = struct('time', ii, 'anntyp', 0, 'subtyp', 0, 'chan', 0, ...
        'num', 0, 'aux', '');
end