% DATA = WFDB_getframe(NSPF);
% DATA = WFDB_getframe(NSPF, NSAMP);
% DATA = WFDB_getframe(NSPF, NSAMP, TSTART);
%
% Read frames from open input signals.
%
% DATA: Signal frames. If signal 0 is sampled twice as fast as signal 1,
%   DATA will be organized as:
%   [sig0samp1    sig0samp2  sig1samp1
%    sig0samp3    sig0samp4  sig1samp2
%       ...          ...         ...
%    sig0samp2n-1 sig0samp2n sig1sampn]
% NSPF: Number of signals per frame. Must be the sum of the 'spf' fields of
%   the Siginfo structure returned by WFDB_isigopen
% NSAMP: (Optional) Number of frames to read.
% TSTART: (Optional) Frame number of the first frame to read.
%
% To read NSAMP frames of each signal, beginning at frame number TSTART:
%   DATA = WFDB_getvec(NSPF, NSAMP, TSTART);
% The first frame of each signal has frame number 0 (not 1!).
%
% To read the next NSAMP frames of each signal:
%   DATA = WFDB_getvec(NSIG, NSAMP);
%
% If the record is not too long, read it all at once by:
%   DATA = WFDB_getvec(NSIG);
%
% http://www.physionet.org
