/*

WFDB_osigfopen.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include "matrix.h"

#define S_INPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int i;

  WFDB_Siginfo *siarray;
  unsigned int nsig, err_code;

  mxArray *field;
  char *the_string;
  unsigned int the_string_length;

  /* Get size of input S and create siarray */
  nsig = mxGetM(prhs[S_INPUT]) * mxGetN(prhs[S_INPUT]);
  siarray = (WFDB_Siginfo *)mxCalloc(nsig, sizeof(WFDB_Siginfo));

  /* Get fname field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "fname");
      the_string_length = mxGetM(field) * mxGetN(field) + 1;
      the_string = (char *)mxCalloc(the_string_length, sizeof(char));
      mxGetString(field, the_string, the_string_length);
      siarray[i].fname = the_string;
    }

  /* Get desc field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "desc");
      the_string_length = mxGetM(field) * mxGetN(field) + 1;
      the_string = (char *)mxCalloc(the_string_length, sizeof(char));
      mxGetString(field, the_string, the_string_length);
      siarray[i].desc = the_string;
    }

  /* Get units field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "units");
      the_string_length = mxGetM(field) * mxGetN(field) + 1;
      the_string = (char *)mxCalloc(the_string_length, sizeof(char));
      mxGetString(field, the_string, the_string_length);
      siarray[i].units = the_string;
    }

  /* Get gain field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "gain");
      siarray[i].gain = *mxGetPr(field);
    }

  /* Get initval field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "initval");
      siarray[i].initval = *mxGetPr(field);
    }

  /* Get group field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "group");
      siarray[i].group = *mxGetPr(field);
    }

  /* Get fmt field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "fmt");
      siarray[i].fmt = *mxGetPr(field);
    }

  /* Get spf field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "spf");
      siarray[i].spf = *mxGetPr(field);
    }

  /* Get bsize field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "bsize");
      siarray[i].bsize = *mxGetPr(field);
    }

  /* Get adcres field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "adcres");
      siarray[i].adcres = *mxGetPr(field);
    }

  /* Get adczero field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "adczero");
      siarray[i].adczero = *mxGetPr(field);
    }

  /* Get baseline field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "baseline");
      siarray[i].baseline = *mxGetPr(field);
    }

  if ((err_code = osigfopen(siarray, nsig)) < 0)
    switch (err_code)
      {
      case -2:
	mexErrMsgTxt("Failure: error in signal specification");
      case -3:
	mexErrMsgTxt("Failure: unable to open output signal(s)");
      default:
	mexErrMsgTxt("Unknown error"); 
      }

  mxFree(siarray);
  mxFree(the_string);
}
