% file: example2.m	G. Clifford and G. Moody	27 November 2003

fprintf('example2.m - demonstration of reading annotations using WFDB_tools\n')

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script is part of a brief 'hands on' tutorial for the WFDB_tools
% package.  Before running this script, you will need to have correctly
% installed the WFDB software package and added the Matlab WFDB_tools
% path at the Matlab prompt.
%
% Please report any problems with this script to Gari Clifford:
%	gari AT physionet DOT org
% Please report any problems with WFDB_tools for Matlab to Jonas Carlson:
%       jonas DOT carlson AT kard DOT lu DOT se
% Please report any problems with the WFDB software package to George Moody:
%       george AT physionet DOT org

% Set pauseflag to 0 before running this script to disable pauses.
if(~exist('pauseflag')) pauseflag=1; end

% Check that the WFDB_tools functions are installed and accessible.
if(exist('WFDB_isigopen')==0)
  fprintf('Please add WFDB_tools to the PATH ...');
  if(isunix)
     error(' e.g.,\n     addpath ~/matlab/WFDB_tools/\n');
  elseif(ispc)
     error(' e.g.,\n     addpath c:\\matlab\\WFDB_tools\n');
  else
     error('... ');
  end
end

% Check that the WFDB software package is installed and accessible.
if system('rdann -r mitdb/201 -a atr -c 1')
  fprintf('The WFDB software package does not seem to be installed.\n');
  error('Install it and add the directory containing "rdann" to your PATH.\n');
end

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

% End of standard setup.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Choose an input record.
record = 'mitdb/201';

% Prepare to open the annotation file.
fprintf('First we must create an annotation structure with\n');
fprintf('   A = WFDB_Anninfo(1);\n');
fprintf('and then we specify the annotator name (file suffix) by\n');
fprintf('   A.name=%satr%s;\n',setstr(39),setstr(39));

A = WFDB_Anninfo(1);       % create annotator info structure
A.name = 'atr';            % choose the annotator (annotation filename suffix)

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

% Open the annotation file.
fprintf('Now we open a file with \n');
fprintf('   WFDB_annopen(record,A);\n');

WFDB_annopen(record,A);

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

% Read annotations into memory.
fprintf('We can read the first two annotations from annotator 0 with\n');
fprintf('   Ann = WFDB_getann(0,2);\n');
Ann = WFDB_getann(0,2)     % read the first two annotations

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

% Inspect the annotations that we just read.
fprintf('Let%ss take a look at the second annotation:\n',setstr(39));
Ann(2)                     % show the contents of the second annotation

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

fprintf('We can convert the annotation type Ann(2).anntyp to a mnemonic by\n');
fprintf('   WFDB_annstr(Ann(2).anntyp)\n');

if(pauseflag==1)
  fprintf('               [Press any key to continue]\n'); 
  pause;
end;

WFDB_annstr(Ann(2).anntyp)

fprintf('We can also get a description of this annotation type by\n');
fprintf('  WFDB_anndesc(Ann(2).anntyp)\n');

WFDB_anndesc(Ann(2).anntyp)

fprintf('\n\nWe finish by closing all files with WFDB_wfdbquit\n');
WFDB_wfdbquit
fprintf('\nWFDB_wfdbquit successful, end of example2.m\n')
