% A = WFDB_Anninfo(NANN);
%
% Create Anninfo structure(s) for use with WFDB_annopen.
%
% NANN: Number of annotators
% A: Resulting Anninfo structure(s)
%
% The fields of A are defaulted as:
% name - 'a0', 'a1', 'a2' ...
% stat - 'WFDB_READ'
%
% name may be any string.
% stat must be either the string 'WFDB_READ' or 'WFDB_WRITE'
%
% http://www.physionet.org

function A = WFDB_Anninfo(NANN);

for ii = 1:NANN
    A(ii) = struct('name', ['a' num2str(ii-1)], 'stat', 'WFDB_READ');
end
