/*

WFDB_physadu.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include "matrix.h"

#define SIG_INPUT 0
#define PHYS_INPUT 1

#define ADU_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int i, nsamp;
  double *adu, *phys;
  double sig;

  unsigned int mrows, ncols;

  phys = mxGetPr(prhs[PHYS_INPUT]);
  sig = *mxGetPr(prhs[SIG_INPUT]);

  mrows = mxGetM(prhs[PHYS_INPUT]);
  ncols = mxGetN(prhs[PHYS_INPUT]);
  nsamp = mrows * ncols;

  plhs[ADU_OUTPUT] = mxCreateDoubleMatrix(mrows, ncols, mxREAL);
  adu = mxGetPr(plhs[ADU_OUTPUT]);

  for (i = 0; i < nsamp; i++)
    *(adu + i) = physadu(sig, *(phys + i));
}
