/*

WFDB_setgvmode.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include <string.h>

#define MODE_INPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  char *mode;
  unsigned int mode_length;

  if (nrhs != 1)
    mexErrMsgTxt("One input required");

  if (mxIsChar(prhs[MODE_INPUT]) != 1)
    mexErrMsgTxt("MODE must be a string");

  mode_length = (mxGetM(prhs[MODE_INPUT]) *
		 mxGetN(prhs[MODE_INPUT])) + 1;
  mode = mxCalloc(mode_length, sizeof(char));

  mxGetString(prhs[MODE_INPUT], mode, mode_length);

  if (strcmp(mode, "WFDB_LOWRES") == 0)
    setgvmode(WFDB_LOWRES);
  else if (strcmp(mode, "WFDB_HIGHRES") == 0)
    setgvmode(WFDB_HIGHRES);
  else
    {
      mexPrintf("MODE: %s unknown.\n", mode);
      mexErrMsgTxt("Use WFDB_LOWRES or WFDB_HIGHRES");
    }

  mxFree(mode);
}
