/*

WFDB_aduphys.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include "matrix.h"

#define SIG_INPUT 0
#define ADU_INPUT 1

#define PHYS_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int i, nsamp;
  double *adu, *phys;
  double sig;

  unsigned int mrows, ncols;

  adu = mxGetPr(prhs[ADU_INPUT]);
  sig = *mxGetPr(prhs[SIG_INPUT]);

  mrows = mxGetM(prhs[ADU_INPUT]);
  ncols = mxGetN(prhs[ADU_INPUT]);
  nsamp = mrows * ncols;

  plhs[PHYS_OUTPUT] = mxCreateDoubleMatrix(mrows, ncols, mxREAL);
  phys = mxGetPr(plhs[PHYS_OUTPUT]);

  for (i = 0; i < nsamp; i++)
    *(phys + i) = aduphys(sig, *(adu + i));
}
