#include "mex.h"
#include "matrix.h"
#include "wfdb/wfdb.h"

/*
 * WFDB_anndesc.c
 *
 * Convert WFDB annotation codes to description.
 * Return as character array or cell of character arrays.
 *
 */
 
/* Define order of input variables */
#define CODE_INPUT 0

/* Define order of output variables */
#define ANN_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int ncodes, i;

  /* Check for correct total number of input arguments. */
  if (nrhs != 1)
    {
      mexErrMsgTxt("One input argument required.");
    }
  
  if ((mxGetM(prhs[CODE_INPUT]) * mxGetN(prhs[CODE_INPUT])) == 1)
    {
      plhs[ANN_OUTPUT] = mxCreateString(anndesc(*mxGetPr(prhs[CODE_INPUT])));
    }
  else
    {
      ncodes = mxGetM(prhs[CODE_INPUT]) * mxGetN(prhs[CODE_INPUT]);
      plhs[ANN_OUTPUT] = mxCreateCellMatrix(ncodes, 1);
      for (i = 0; i < ncodes; i++)
	mxSetCell(plhs[ANN_OUTPUT], i, 
		  mxCreateString(anndesc(*(mxGetPr(prhs[CODE_INPUT]) + i))));
    }

}
