#include "mex.h"
#include "matrix.h"
#include "wfdb/wfdb.h"

/*
 * WFDB_mstimstr.c
 *
 * Convert time to ASCII string.
 *
 */
 
/* Define order of input variables */
#define TIME_INPUT 0

/* Define order of output variables */
#define BASETIME_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  char *record;
  unsigned int record_length;

  /* Check for correct total number of input arguments. */
  if (nrhs != 1)
    {
      mexErrMsgTxt("One input argument required.");
    }
  
  /* Convert time to string */
  plhs[BASETIME_OUTPUT] = mxCreateString(mstimstr(*mxGetPr(prhs[TIME_INPUT])));

}
