/*

WFDB_muvadu.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include "matrix.h"

#define SIG_INPUT 0
#define MUV_INPUT 1

#define ADU_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int i, nsamp;
  double *adu, *muv;
  double sig;

  unsigned int mrows, ncols;

  muv = mxGetPr(prhs[MUV_INPUT]);
  sig = *mxGetPr(prhs[SIG_INPUT]);

  mrows = mxGetM(prhs[MUV_INPUT]);
  ncols = mxGetN(prhs[MUV_INPUT]);
  nsamp = mrows * ncols;

  plhs[ADU_OUTPUT] = mxCreateDoubleMatrix(mrows, ncols, mxREAL);
  adu = mxGetPr(plhs[ADU_OUTPUT]);

  for (i = 0; i < nsamp; i++)
    *(adu + i) = muvadu(sig, *(muv + i));
}
