/*

WFDB_newheader.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"

#define RECORD_INPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  char *record;
  unsigned int record_length;

  /* Get the RECORD string */
  if (!mxIsChar(prhs[RECORD_INPUT]))
    mexErrMsgTxt("RECORD must be a string.");
  record_length = (mxGetM(prhs[RECORD_INPUT]) *
		   mxGetN(prhs[RECORD_INPUT])) + 1;
  record = mxCalloc(record_length, sizeof(char));
  mxGetString(prhs[RECORD_INPUT], record, record_length);

  /* Call newheader */
  newheader(record);

  mxFree(record);
}
