/*

WFDV_setbasetime.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"

#define BASETIME_INPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  int err_code;

  unsigned int basetime_length;
  char *basetime;

  if (nrhs > 1)
    mexErrMsgTxt("One or no input argument");

  if (nrhs == 1)
    {
      /* Get the BASETIME string */
      if (!mxIsChar(prhs[BASETIME_INPUT]))
	mexErrMsgTxt("BASETIME must be a string.");
      basetime_length = (mxGetM(prhs[BASETIME_INPUT]) *
			 mxGetN(prhs[BASETIME_INPUT])) + 1;
      basetime = mxCalloc(basetime_length, sizeof(char));
      mxGetString(prhs[BASETIME_INPUT], basetime, basetime_length);

      err_code = setbasetime(basetime);

      mxFree(basetime);
    }
  else
    err_code = setbasetime(NULL);

  if (err_code < 0)
    switch (err_code)
      {
      case -1:
	mexErrMsgTxt("Failure: incorrect string format");
      default:
	mexErrMsgTxt("Unknown error");
      }

}
