/*

WFDB_wfdbfile.c

*/

#include "mex.h"
#include "matrix.h"
#include "wfdb/wfdb.h"

#define TYPE_INPUT 0
#define RECORD_INPUT 1

#define FILE_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  char *type, *record;
  unsigned int type_length, record_length;

  if ( (nrhs < 1) || (nrhs > 2) )
    mexErrMsgTxt("One or two arguments required");

  type_length = mxGetM(prhs[TYPE_INPUT]) * mxGetN(prhs[TYPE_INPUT]) + 1;
  type = mxCalloc(type_length, sizeof(char));
  mxGetString(prhs[TYPE_INPUT], type, type_length);

  if (nrhs == 1)
    plhs[FILE_OUTPUT] = mxCreateString(wfdbfile(type, NULL));
  else
    {
      record_length = mxGetM(prhs[RECORD_INPUT]) * 
	mxGetN(prhs[RECORD_INPUT]) + 1;
      record = mxCalloc(record_length, sizeof(char));
      mxGetString(prhs[RECORD_INPUT], record, record_length);

      plhs[FILE_OUTPUT] = mxCreateString(wfdbfile(type, record));

      mxFree(record);
    }

  mxFree(type);

}
