% WFDB tools
% v0.5.0 26 November 2003
%
% Selecting database records.
%   WFDB_annopen      - Open input and/or output annotation files
%   WFDB_isigopen     - Open input signal file
%   WFDB_osigopen     - Open output signal file
%   WFDB_osigfopen    - Open output signal file
%
% Special input modes.
%   WFDB_setifreq     - Set current input sampling frequency
%   WFDB_getifreq     - Get current input sampling frequency
%   WFDB_setgvmode    - Set WFDB_getvec input mode
%   WFDB_getspf       - Get number of samples per signal per frame
%
% Reading and writing signals and annotations.
%   WFDB_getvec       - Read sample from input data file
%   WFDB_getframe     - Read frame from input data file
%   WFDB_putvec       - Write signal data to output file
%   WFDB_getann       - Read annotation
%   WFDB_putann       - Write annotation
%
% Non-sequential access to WFDB files.
%   WFDB_isigsettime  - Set input signal file pointer
%   WFDB_isgsettime   - Set signal group file pointer
%   WFDB_iannsettime  - Set input annotation file pointer
%
% Conversion functions.
%   WFDB_annstr       - Convert from annotation number to mnemonic
%   WFDB_anndesc      - Convert from annotation number to description
%   WFDB_ecgstr       - Convert from annotation number to mnemonic
%   WFDB_strann       - Convert from annotation mnemonic to number
%   WFDB_strecg       - Convert from annotation mnemonic to number
%   WFDB_timstr       - Convert from sample number to time (interval)
%   WFDB_mstimstr     - Convert from sample number to time (interval) in ms
%   WFDB_strtim       - Convert from time to sample number
%   WFDB_datstr       - Convert from Julian date to string
%   WFDB_strdat       - Convert from string to Julian date
%   WFDB_aduphys      - Convert from A/D units to physical units
%   WFDB_physadu      - Convert from physical units to A/D units
%   WFDB_adumuv       - Convert from A/D units to microVolts
%   WFDB_muvadu       - Convert from microVolts to A/D units
%
% Miscellaneous WFDB functions.
%   WFDB_newheader    - Create header file
%   WFDB_setheader    - Create or recreate header
%   WFDB_wfdbquit     - Close all open files and reset
%   WFDB_iannclose    - Close input annotator
%   WFDB_oannclose    - Close output annotator
%   WFDB_wfdbquiet    - Disable error reporting from WFDB functions
%   WFDB_wfdbverbose  - Enable error reporting from WFDB functions
%   WFDB_wfdberror    - Get last error message (or version number)
%   WFDB_sampfreq     - Get sampling frequency of a record
%   WFDB_setsampfreq  - Set sampling frequency of a record
%   WFDB_setbasetime  - Set basetime of recording
%   WFDB_getcfreq     - Get counter frequency
%   WFDB_setcfreq     - Set counter frequency
%   WFDB_getbasecount - Get base counter value
%   WFDB_setbasecount - Set base counter value
%   WFDB_getwfdb      - Get WFDB database path
%   WFDB_wfdbfile     - Search file in database path
%   WFDB_wfdbflush    - Empty output buffers
%   WFDB_getinfo      - Get info text from a header file
%   WFDB_putinfo      - Add info text to a header file
%   WFDB_wfdbgetskew  - Get signal skew
%   WFDB_wfdbsetskew  - Set signal skew
%   WFDB_wfdbgetstart - Get prolog length
%   WFDB_wfdbsetstart - Set prolog length
%
% Creating structures.
%   WFDB_Anninfo      - Create annotator structure
%   WFDB_Annotation   - Create annotation structure
%   WFDB_Siginfo      - Create output signal information structure
