% WFDB_setgvmode(MODE);
%
% Set the mode used by WFDB_getvec when reading a multi-frequency record.
% If MODE is 'WFDB_LOWRES', WFDB_getvec decimates oversampled signals.
% If MODE is 'WFDB_HIGHRES', WFDB_getvec interpolates signals sampled at
% a lower frequency (repeating the last sample value).
%
% Example: Signal 0 is sampled using 100 Hz and signal 1 using 200Hz. With
%   WFDB_LOWRES, WFDB_getvec returns samples using 100 Hz and signal 1 is
%   decimated from 200 Hz to 100 Hz. With WFDB_HIGHRES, WFDB_getvec returns
%   samples using 200 Hz and signal 0 is interpolated from 100 Hz to 200
%   Hz.
%
% WFDB_setgvmode also affects how annotations are read and written. If
% WFDB_setgvmode('WFDB_HIGHRES') is invoked before using WFDB_annopen,
% WFDB_getvec, WFDB_sampfreq, WFDB_strtim, or WFDB_timstr, then all time data
% (including the time attributes of annotations read by WFDB_getann or written
% by WFDB_putann) visible to the application are in units of the
% high-resolution sampling intervals. (Otherwise, time data are in units of
% frame intervals.)
%
% MODE: String. Either 'WFDB_LOWRES' or 'WFDB_HIGHRES'.
%   Default is 'WFDB_LOWRES'.
%
% http://www.physionet.org