/*

WFDB_adumuv.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include "matrix.h"

#define SIG_INPUT 0
#define ADU_INPUT 1

#define MUV_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int i, nsamp;
  double *adu, *muv;
  double sig;

  unsigned int mrows, ncols;

  adu = mxGetPr(prhs[ADU_INPUT]);
  sig = *mxGetPr(prhs[SIG_INPUT]);

  mrows = mxGetM(prhs[ADU_INPUT]);
  ncols = mxGetN(prhs[ADU_INPUT]);
  nsamp = mrows * ncols;

  plhs[MUV_OUTPUT] = mxCreateDoubleMatrix(mrows, ncols, mxREAL);
  muv = mxGetPr(plhs[MUV_OUTPUT]);

  for (i = 0; i < nsamp; i++)
    *(muv + i) = adumuv(sig, *(adu + i));
}
