/*

WFDB_isgsettime.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include "matrix.h"

#define SIG_INPUT 0
#define TIME_INPUT 1

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  int err_code;
  double sig, time;

  unsigned int mrows, ncols;

  if (nrhs != 2)
    mexErrMsgTxt("Two inputs required");

  time = *mxGetPr(prhs[TIME_INPUT]);
  sig = *mxGetPr(prhs[SIG_INPUT]) - 1;

  if ( (err_code = isgsettime(sig, time)) < 0)
    switch (err_code)
      {
      case -1:
	mexErrMsgTxt("Failure: EOF reached or improper seek");
      case -2:
	mexErrMsgTxt("Failure: incorrect signal group number specified");
      default:
	mexErrMsgTxt("Unknown error");
      }
}
