/*

WFDB_putvec.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"

#define ECG_INPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int t, i;

  WFDB_Sample *v;
  int err_code;

  double *ecg;
  unsigned int mrows, ncols;

  mrows = mxGetM(prhs[ECG_INPUT]);
  ncols = mxGetN(prhs[ECG_INPUT]);

  if (ncols > mrows)
    mexErrMsgTxt("Input signals must be stored in columns");

  v = (WFDB_Sample *)mxMalloc(ncols * sizeof(WFDB_Sample));

  /* Data output */
  ecg = mxGetPr(prhs[ECG_INPUT]);
  for (t = 0; t < mrows; t++)
    {
      for (i = 0; i < ncols; i++)
	v[i] = *(ecg + i*mrows + t);
      if ((err_code = putvec(v)) < 0)
	switch (err_code)
	  {
	  case -1:
	    mexErrMsgTxt("Failure: write error");
	  default:
	    mexErrMsgTxt("Unknown error"); 
	  }
    }

  mxFree(v);
}
