/*

WFDB_setsampfreq.c

*/
 
#include "mex.h"
#include "wfdb/wfdb.h"

/* Define order of input variables */
#define FS_INPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  int err_code, mrows, ncols;

  if (nrhs != 1)
    mexErrMsgTxt("One input argument required");

  mrows = mxGetM(prhs[FS_INPUT]);
  ncols = mxGetN(prhs[FS_INPUT]);
  if ( !mxIsDouble(prhs[FS_INPUT]) ||
       mxIsComplex(prhs[FS_INPUT]) ||
       (mrows*ncols != 1) )
    mexErrMsgTxt("SAMPFREQ must be a non-complex scalar double");

  if ((err_code = setsampfreq(*mxGetPr(prhs[FS_INPUT]))) < 0)
    switch (err_code)
      {
      case -1:
	mexErrMsgTxt("Failure: illegal sampling frequency specified");
      default:
	mexErrMsgTxt("Unknown error");
      }

}
