#include "mex.h"
#include "matrix.h"
#include "wfdb/wfdb.h"

/*
 * WFDB_strtim.c
 *
 */
 
/* Define order of input variables */
#define STR_INPUT 0

/* Define order of output variables */
#define DAT_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  char *str;
  unsigned int str_length;

  /* Check for correct total number of input arguments. */
  if (nrhs != 1)
    {
      mexErrMsgTxt("One input argument required.");
    }

  /* Check input */
  if (mxIsChar(prhs[STR_INPUT]))
    {
      str_length = (mxGetM(prhs[STR_INPUT]) * mxGetN(prhs[STR_INPUT])) + 1;
      str = mxCalloc(str_length, sizeof(char));
      mxGetString(prhs[STR_INPUT], str, str_length);
      plhs[DAT_OUTPUT] = mxCreateDoubleScalar(strdat(str));
    }
  else
    mexErrMsgTxt("Input must be a string");
}
