% DATA = WFDB_getvec(NSIG);
% DATA = WFDB_getvec(NSIG, NSAMP);
% DATA = WFDB_getvec(NSIG, NSAMP, TSTART);
%
% Read samples from open input signals.
%
% NSIG: Number of signals.
% NSAMP: (Optional) Number of samples to read.
% TSTART: (Optional) Sample number of the first sample to read
%
% Usage:
% First, get the number of signals by
%   S = WFDB_isigopen(record);
%   NSIG = length(S);
%
% To read NSAMP samples of each signal, beginning at sample number TSTART:
%   DATA = WFDB_getvec(NSIG, NSAMP, TSTART);
% The first sample of each signal has sample number 0 (not 1!).
%
% To read the next NSAMP samples of each signal:
%   DATA = WFDB_getvec(NSIG, NSAMP);
%
% If the record is not too long, read it all at once by:
%   DATA = WFDB_getvec(NSIG);
%
% http://www.physionet.org
