#include "mex.h"
#include "matrix.h"
#include "wfdb/wfdb.h"

/*
 * WFDB_datstr.c
 *
 */
 
/* Define order of input variables */
#define DAT_INPUT 0

/* Define order of output variables */
#define STR_OUTPUT 0

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  /* Check for correct total number of input arguments. */
  if (nrhs != 1)
    {
      mexErrMsgTxt("One input argument required.");
    }
  
  plhs[STR_OUTPUT] = mxCreateString(datstr(*mxGetPr(prhs[DAT_INPUT])));

}
