/*

WFDB_setheader.c

*/

#include "wfdb/wfdb.h"
#include "mex.h"
#include "matrix.h"

#define RECORD_INPUT 0
#define S_INPUT 1
#define NSIG_INPUT 2

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )
{
  unsigned int i;

  WFDB_Siginfo *siarray;
  unsigned int nsig, err_code;

  mxArray *field;
  char *the_string;
  unsigned int the_string_length;

  char *record;
  unsigned int record_length;

  /* Get size of input S and create siarray */
  nsig = (unsigned int)*mxGetPr(prhs[NSIG_INPUT]);
  if (nsig > (mxGetM(prhs[S_INPUT]) * mxGetN(prhs[S_INPUT])))
    mexErrMsgTxt("NSIG must be <= length(S)");

  siarray = (WFDB_Siginfo *)mxCalloc(nsig, sizeof(WFDB_Siginfo));

  /* Get fname field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "fname");
      the_string_length = mxGetM(field) * mxGetN(field) + 1;
      the_string = (char *)mxCalloc(the_string_length, sizeof(char));
      mxGetString(field, the_string, the_string_length);
      siarray[i].fname = the_string;
    }

  /* Get desc field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "desc");
      the_string_length = mxGetM(field) * mxGetN(field) + 1;
      the_string = (char *)mxCalloc(the_string_length, sizeof(char));
      mxGetString(field, the_string, the_string_length);
      siarray[i].desc = the_string;
    }

  /* Get units field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "units");
      the_string_length = mxGetM(field) * mxGetN(field) + 1;
      the_string = (char *)mxCalloc(the_string_length, sizeof(char));
      mxGetString(field, the_string, the_string_length);
      siarray[i].units = the_string;
    }

  /* Get gain field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "gain");
      siarray[i].gain = *mxGetPr(field);
    }

  /* Get initval field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "initval");
      siarray[i].initval = *mxGetPr(field);
    }

  /* Get group field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "group");
      siarray[i].group = *mxGetPr(field);
    }

  /* Get fmt field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "fmt");
      siarray[i].fmt = *mxGetPr(field);
    }

  /* Get spf field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "spf");
      siarray[i].spf = *mxGetPr(field);
    }

  /* Get bsize field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "bsize");
      siarray[i].bsize = *mxGetPr(field);
    }

  /* Get adcres field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "adcres");
      siarray[i].adcres = *mxGetPr(field);
    }

  /* Get adczero field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "adczero");
      siarray[i].adczero = *mxGetPr(field);
    }

  /* Get baseline field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "baseline");
      siarray[i].baseline = *mxGetPr(field);
    }

  /* Get nsamp field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "nsamp");
      siarray[i].nsamp = *mxGetPr(field);
    }

  /* Get cksum field */
  for (i = 0; i < nsig; i++)
    {
      field = mxGetField(prhs[S_INPUT], i, "cksum");
      siarray[i].cksum = *mxGetPr(field);
    }

  /* Get the RECORD string. */
  record_length = (mxGetM(prhs[RECORD_INPUT]) *
                     mxGetN(prhs[RECORD_INPUT])) + 1;
  record = mxCalloc(record_length, sizeof(char));
  mxGetString(prhs[RECORD_INPUT], record, record_length);

  if ((err_code = setheader(record, siarray, nsig)) < 0)
    switch (err_code)
      {
      case -1:
	mexErrMsgTxt("Failure: unable to create header file");
      default:
	mexErrMsgTxt("Unknown error"); 
      }

  mxFree(siarray);
  mxFree(the_string);
  mxFree(record);
}
